/*
 Exemple Fading
 Version française de Exemples > Analog > Fading
 
 Cet exemple montre comment diminuer la brillance d'une LED
 en utilisant la fonction analogWrite()
 Le circuit:
 * LED reliée à la broche 9 et à la masse GND
 Original créé le 1er novembre 2008
 par David A. Mellis
 modifié le 30 Août 2011 
 par Tom Igoe


 http://arduino.cc/en/Tutorial/Fading

 Cet exemple est dans le domaine public

 */


int brocheLed = 9;    // LED reélée à la broche digitale 9

void setup() {
  // Il n'y a rien dans cette fonction
}

void loop() {
  // Augmentation progressive du minimum au maximum
  // par incréments de 5 unités :
  for(int valeurSortie = 0; valeurSortie <= 255; valeurSortie +=5) {
    // Fixe la valeur (de 0 à 255) :
    analogWrite(brocheLed, valeurSortie);
    // Pause de 30 millisecondes permettant de voir l’effet :
    delay(30);
  }
  // Diminution progressive du maximum au minimum
  // par incréments de 5 unités :
  for(int valeurSortie = 255; valeurSortie >= 0; valeurSortie -=5) {
    // Fixe la valeur (de 0 à 255) :
    analogWrite(brocheLed, valeurSortie);
    // Pause de 30 millisecondes permettant de voir l’effet :
    delay(30);
  }
}

